<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Popunder Example on Click</title>
    <script>
        // Array of random direct links
        const links = [
            'https://pandamovies.pw',
            'https://pandamovies.pw',
            'https://pandamovies.pw',
            'https://pandamovies.pw',
            'https://pandamovies.pw'
        ];

        // Function to set a cookie that expires at the end of the session
        function setCookie(name, value) {
            document.cookie = name + "=" + value + ";path=/"; // No expires attribute creates a session cookie
        }

        // Function to get a cookie by name
        function getCookie(name) {
            const nameEQ = name + "=";
            const ca = document.cookie.split(';');
            for (let i = 0; i < ca.length; i++) {
                let c = ca[i];
                while (c.charAt(0) === ' ') c = c.substring(1);
                if (c.indexOf(nameEQ) === 0) return c.substring(nameEQ.length, c.length);
            }
            return null;
        }

        // Function to open popunder
        function openPopunder() {
            // Select a random link from the array
            const randomLink = links[Math.floor(Math.random() * links.length)];

            // Open a new window/popunder
            const popunder = window.open(randomLink, '_blank');

            // Check for popunder support and focus on the original window
            if (popunder) {
                popunder.blur(); // Optional, move focus away from the new window
                window.focus(); // Bring focus back to the original window
            }
        }

        // Prevent multiple popunders from opening on rapid clicks
        let isPopunderOpen = false;

        // Attach click event listener to open popunder on any click
        document.addEventListener('click', function() {
            // Get the current count of popunders opened
            let popunderCount = parseInt(getCookie('popunderCount')) || 0;

            // Allow opening popunders until we reach the limit of 3
            if (!isPopunderOpen && popunderCount < 3) {
                isPopunderOpen = true; // Disable further popunders for a moment
                openPopunder(); // Open the popunder
                
                // Increment the popunder count and set it in cookie
                popunderCount++; // Increment count
                setCookie('popunderCount', popunderCount); // Set cookie as a session cookie

                // Reset the flag after a brief delay to allow for more clicks
                setTimeout(() => {
                    isPopunderOpen = false; // Allow another popunder to open after 1 second
                }, 1000); // 1000 milliseconds = 1 second
            }
        });
    </script>
</head>
<body>
    <h1>Popunder Example on Click</h1>
    <p>This page will open a popunder when you click anywhere on the page, up to a maximum of 3 times.</p>
</body>
</html>
