<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Popunder Example Limited Openings</title>
    <script>
        // Array of random direct links
        const links = [
            'https://www.example.com',
            'https://www.anotherexample.com',
            'https://www.yetanotherexample.com',
            'https://www.somethingdifferent.com',
            'https://www.randomsite.com'
        ];

        // Variables to track popunder status
        let popunderCount = 0;
        const maxPopunders = 3;      // Maximum number of popunders allowed
        const timeFrame = 6 * 60 * 60 * 1000; // 6 hours in milliseconds
        let lastPopunderTime = 0;     // Timestamp of the last opened popunder

        // Function to open popunder
        function openPopunder() {
            // Select a random link from the array
            const randomLink = links[Math.floor(Math.random() * links.length)];

            // Open a new window/popunder
            const popunder = window.open(randomLink, '_blank');

            // Check for popunder support and focus on the original window
            if (popunder) {
                popunder.blur(); // Move focus away from the new window
                window.focus(); // Bring focus back to the original window
            }

            // Update popunder tracking variables
            popunderCount++;
            lastPopunderTime = Date.now();
        }

        // Event listener for click on the document
        document.addEventListener('click', function() {
            const currentTime = Date.now();

            // Check if we can open a popunder
            if (popunderCount < maxPopunders) {
                // Check if 2 hours have passed since the last popunder
                if (currentTime - lastPopunderTime >= (2 * 60 * 60 * 1000)) {
                    openPopunder(); // Open the popunder
                } else {
                    console.log("Wait at least 2 hours between popunders.");
                }
            } else {
                console.log("Maximum popunders opened within the timeframe.");
            }
        });

    </script>
</head>
<body>
    <h1>Popunder Example Limited Openings</h1>
    <p>This page will open a popunder a maximum of 3 times within 6 hours when you click anywhere on the page.</p>
</body>
</html>
