<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ad Blocker Detection</title>
    <script>
        function isHidden(e) {
            return "none" === window.getComputedStyle(e).display;
        }

        function reload() {
            window.location.href = window.location.href;
        }

        function hasClass(e, d) {
            return !!e.className.match(new RegExp("(\\s|^)" + d + "(\\s|$)"));
        }

        function addClass(e, d) {
            hasClass(e, d) || (e.className += " " + d);
        }

        function removeClass(e, d) {
            if (hasClass(e, d)) {
                var a = new RegExp("(\\s|^)" + d + "(\\s|$)");
                e.className = e.className.replace(a, " ");
            }
        }

        document.addEventListener("DOMContentLoaded", init, false);

        let ads = document.createElement("script");
        ads.setAttribute("src", "https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js");
        document.head.appendChild(ads);

        let intervalId;

        function adde_modal_detector(e) {
            const overlays = document.querySelectorAll(".modal-overlay");
            const modals = document.querySelectorAll(".modal");
            overlays.forEach(overlay => {
                if (e) {
                    addClass(overlay, "active");
                } else {
                    removeClass(overlay, "active");
                }
            });
            modals.forEach(modal => {
                if (e) {
                    addClass(modal, "adde_modal_detector-show");
                    removeClass(modal, "adde_modal_detector-hide");
                } else {
                    removeClass(modal, "adde_modal_detector-show");
                    addClass(modal, "adde_modal_detector-hide");
                }
            });
        }

        function checkMultiple() {
            let e = false;
            const d = document.createElement("div");
            d.innerHTML = "&nbsp;";
            d.className = "adsbox";
            try {
                document.body.appendChild(d);
                var a = document.querySelector(".adsbox");
                e = !a || 0 === a.offsetHeight;
            } finally {
                d.parentNode.removeChild(d);
            }
            return e;
        }

        function init() {
            adsBlocked(function(e) {
                adde_modal_detector(e);
                const message = e ? "Ad Blocker Detected: Please disable your ad blocker to support us." : "Thank you for supporting us!";
                const messageDivs = document.querySelectorAll(".adblock-message");
                messageDivs.forEach(div => {
                    div.innerText = message;
                });
            });
        }

        function adsBlocked(e) {
            var d = new Request("https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js", { method: "HEAD", mode: "no-cors" });
            fetch(d).then(function(d) {
                e(false);
            }).catch(function(d) {
                e(true);
            });
        }

        window.onload = (e => {
            intervalId = window.setInterval(function() {
                init();
            }, 100);
        });
    </script>
    <style>
        #adblock-message {
            font-size: 20px;
            margin: 20px;
        }
        .modal-overlay.active {
            display: block; /* Show modal overlay */
        }
        /* Add more styles as needed */
    </style>
</head>
<body>
    <div class="modal-overlay"></div>
    <div class="modal">
        <!-- Modal content can go here -->
    </div>
    <div class="adblock-message">Checking for ad blocker...</div>
    
    <div class="modal-overlay"></div>
    <div class="modal">
        <!-- Modal content can go here -->
    </div>
    <div class="adblock-message">Checking for ad blocker...</div>
    
    <div class="modal-overlay"></div>
    <div class="modal">
        <!-- Modal content can go here -->
    </div>
    <div class="adblock-message">Checking for ad blocker...</div>
</body>
</html>
